use xide;
#------------------------------------First volume: Templates, tags-----------------------------------------

#------------------------------------- Tables creation ------------------------------------- 

#-- Templates table stores information about elements, that can be reused (component templates and pages and application samples). 
#-- In this table each entry is called template; each template is a reference to a reusable item and contains some information about it, used for search purpose.
#-- When template is used by the user, all information about the template is parced from the file system. 

CREATE TABLE templates (
	template_id 		varchar(200),				#-- ID of the template 
	template_title 		varchar(200) NOT NULL, 		#-- Title of the template
	description 		text, 						#-- Template description
	author 				varchar(100),				#-- Username of the template author 
	creation_date 		timestamp, 					#-- Date of creation (publishing)
	template_type 		int,						#-- Type of the template: 1 - Applicaiton sample; 2 - Page sample; 3 - Component sample
	folder_path 		varchar(500), 				#-- Path to the folder, which contains files related to the template
	do_work 			boolean	,					#-- Indicates whether this template works and can be dragged
	PRIMARY KEY (template_id)
	);

#-- Tags table stores infromation about different XIDE tags. When tag is created by the user, it is added to the table.
#-- Each template element (component templates and pages and application samples) can have one or more tag assigned.
CREATE TABLE tags (
	tag_id 			int AUTO_INCREMENT,				#-- ID of the tag
	title			varchar(200), 					#-- Title of the tag (shown to the user in the tag list)
	description		text, 							#-- Tag description
	PRIMARY KEY (tag_id)
);

#-- This table contains infromation about tag assignments. It stores many-to-many relationship between tags and templates tables
CREATE TABLE used_tags_map (
	tag_id 			int REFERENCES tags,				#-- Reference to the tag ID
	template_id 	varchar(200) REFERENCES templates	#-- Reference to the template ID
);

# ---------------------------- Data Load -----------------------------------------------------------------------------------------------
#-- There is no initial data load for these tables. 
#-- When some action in performed in XIDE (e.g. new component is created, new tag is created, new tag is assigned), 
#-- information is automatically added to the database.  

#-- If there are some existing templates or tags, which should be added to the database, please see the following example.

# ---------------------------- Data Load Examples --------------------------------------------------------------------------------------

#--INSERT INTO templates VALUES ('tpl_test_component',
#--'Test Component', 
#--'This is a test component template',
#--'test_username',
#--NOW(),
#--3, 
#--'tpl_test_component/');

#--INSERT INTO tags(title, description) VALUES( 
#--'Test Tag',
#--'This is a test tag');

#--INSERT INTO used_tags_map VALUES( 
#--*id given to the Test Tag *,
#--'tpl_test_component');



