<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Import the identity transformation -->
	<xsl:import href="identity.xsl" />
	<!-- Define the output format -->
	<xsl:output method="xml" version="1.0" />
 	<!-- Define the parameters -->
	<xsl:param name="paramDataIdAttributeValueCounter" select="0" />
	<xsl:param name="paramDataIdAttributeValuePrefix" select="''" />
	<xsl:param name="paramDataIdAttributeNamespaceURI" select="''" />
	<xsl:param name="paramDataIdAttributeLocalName" select="''" />
	<xsl:param name="paramDataIdAttributeQName" select="''" />



	<!-- Transform each element that does not have the data ID attribute -->
	<xsl:template match="//*[ count( @*[ local-name() = $paramDataIdAttributeLocalName and namespace-uri() = $paramDataIdAttributeNamespaceURI ] ) = 0 ]">
		<!-- Calculate the value counter for the element that does not have the data ID attribute -->
 		<xsl:variable name="varDataIdAttributeValueCounter" select="count( ( ancestor::* | preceding::* )[ count( @*[ local-name() = $paramDataIdAttributeLocalName and namespace-uri() = $paramDataIdAttributeNamespaceURI ] ) = 0 ] ) + $paramDataIdAttributeValueCounter" />
		<!-- Retain the element name -->
		<xsl:element name="{ name() }" namespace="{ namespace-uri() }">
 			<!-- Add the data ID attribute -->
			<xsl:attribute name="{ $paramDataIdAttributeQName }" namespace="{ $paramDataIdAttributeNamespaceURI }">
				<xsl:value-of select="concat( $paramDataIdAttributeValuePrefix, $varDataIdAttributeValueCounter )" />
			</xsl:attribute>
			<!-- Copy the other attributes -->
			<xsl:copy-of select="@*" />
			<!-- Apply further templates -->
 			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>



</xsl:stylesheet>