use xide;
#------------------------------ Third volume: properties--------------------------------------------------------------------------------

#------------------------------ Tables creation ---------------------------------------------------------------------------------------- 

#-- This table stores infromation about properties. 

#-- In XIDE information about each object is represented as a set of properties. Each property contains the value and information about
#-- it: how is it called (title), what is it for (description), can it be edited by the user, etc. 

#-- Example: property to store url of the application
#-- value: www.xide.com/application.xformsdb; 
#-- title: Applciation URL; 
#-- description: URL where the application is published and can be accessed externally   

#-- There are many different property types; objects of the same type have the same set of properties. 
#-- Generally, each column in the table, where object information is stored, should be parsed into single property object. 
#-- Except the value, two properties of the same type have the same descriptive information (title, description, different flags).  
#-- For each property type there is an entry in properties_info table.
 
#-- When the object is parsed, corresponding properties are created according to the information from properties_info table,
#-- and the values from the object information are stored into those properties.

#-- Each property has its own unique code in order to be able to find necessary property. 
#-- Codes stored in this table should be synchronized with constants defined in Property class.

#-- Property data type column defines the type of the value stored in the property. According to this type, property value will be 
#-- automatically displayed as using appropriate UI element (checkbox for boolean, textbox for text, etc.). 

#-- Data types are:
#--	0 - text (e.g. Template Title or Application URL)
#-- 1 - boolean (e.g. Is application public)
#-- 2 - textarea 
#-- 3 - system data, should not be shown to the user (e.g. template_type)
#-- 4 - array 
#-- 5 - data
  
CREATE TABLE properties_info (
	prop_id 			int AUTO_INCREMENT,				#-- ID of the property
	prop_title			varchar(200), 					#-- Name of the propery
	description			text, 							#-- Property description
	is_obligatory		boolean,						#-- Is this property obligatory for the elelemt (true if yes)
	is_hidden			boolean,						#-- Is this property a hidden property, i.e. never showed for a user (true if yes)
	is_never_editable	boolean,						#-- Is this property a never edited by user property, e.g. ID or date (true if yes)
	table_name			varchar(200),					#-- Name of the table where property is taken from
	column_name			varchar(200),					#-- Name of the column where property is taken from
	prop_code			varchar(200),					#-- Property code for the XIDE application
	data_type			int,							#-- Property data type 
	PRIMARY KEY (prop_id)
	);


CREATE TABLE used_properties_map (
	prop_id 			int REFERENCES properties_info,	#-- ID of the property
	user_id				varchar(200)					#-- ID of the user
);

#------------------------------ Loading data into propeties_info table ----------------------------------------------------------------- 
#-- These values should be loaded to support appropriate work of XIDE. All changes to content of this table should be 
#-- performed in synchronization with other tables and Property class.  


#------------------------------ Properties related to Templates table-------------------------------------------------------------------

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Template ID',
'ID of the temlate',
true, false, true,
'templates',
'template_id',
'ID', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) 
							VALUES (
'Template title',
'Title of the temlate',
true, false, false,
'templates',
'template_title',
'Title', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Template description',
'Description of the temlate',
false, false, false,
'templates',
'description',
'Description', 0);

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Template author',
'Author of the temlate',
false, false, true,
'templates',
'author',
'Author', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Template creation date',
'Author of the temlate',
false, false, true,
'templates',
'creation_date',
'Date_Creation', 5);

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Template type',
'Type of the temlate',
false, true, true,
'templates',
'template_type',
'Type', 3);

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Do work',
'Shows is this a working template (can be dragged)',
false, false, false,
'templates',
'do_work',
'Do_Work', 1);


#------------------------------ Properties related to Applications table ---------------------------------------------------------------

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Application ID',
'ID of the Application',
true, true, true,
'applications',
'application_id',
'ID', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application title',
'Title of the Application',
true, false, false,
'applications',
'application_title',
'Title', 0);


INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Application description',
'Description of the Application',
false, false, false,
'applications',
'description',
'Description', 0);

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Application author',
'Author of the Application',
false, false, true,
'applications',
'author',
'Author', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application url',
'url of the Application',
false, false, true,
'applications',
'url',
'URL', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application creation date',
'Creation date of the Application',
false, false, true,
'applications',
'creation_date',
'Date_Creation', 5);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application modification date',
'Modification date of the Application',
false, false, true,
'applications',
'modification_date',
'Date_Modification', 5);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application publishing date',
'publishing date of the Application',
false, false, true,
'applications',
'publishing_date',
'Date_Publication', 5);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Is public application',
'Is public  Application (shown to others)',
false, false, false,
'applications',
'is_public',
'Is_shown', 1);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application is published',
'Application is published and can be accessed online',
false, false, true,
'applications',
'status',
'Is_published', 1);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Related URL for application',
'Related URL for the application',
true, false, true,
'applications',
'rel_url',
'Related_URL', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Main page',
'Main page of the application',
false, false, false,
'applications',
'main_page',
'Main_Page', 3);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Is demo application',
'Is this applciation a demo application (shown to others, cannot be edited)',
false, false, true,
'applications',
'is_demo',
'Is_Demo', 1);


#------------------------------ Properties related to Pages table ----------------------------------------------------------------------

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Page ID',
'ID of the page',
true, true, true,
'pages',
'page_id',
'ID', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Page title',
'Title of the page',
true, false, false,
'pages',
'page_title',
'Title', 0);


INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Page Descrescription',
'Descr of the page',
false, false, false,
'pages',
'description',
'Description', 0);

INSERT INTO properties_info  (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type) VALUES (
'Page creation date',
'Creation date of the page',
false, false, true,
'pages',
'creation_date',
'Date_Creation', 5);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Page modification date',
'Modification date of the page',
false, false, true,
'pages',
'modification_date',
'Date_Modification', 5);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Application ID',
'Application ID',
false, true, true,
'pages',
'application_id',
'Application_id', 0);


INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Related URL',
'Related URL for the page',
true, false, true,
'pages',
'rel_url',
'Related_URL', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Folder path',
'Path of the folder which represents files of this application on a server',
true, true, true,
'applications',
'folder_path',
'Folder_Path', 0);

INSERT INTO properties_info (prop_title,	description, is_obligatory, is_hidden, 
							is_never_editable, table_name, column_name, prop_code, data_type)  VALUES (
'Folder path',
'Path of the folder which represents files of this template on a server',
true, true, true,
'templates',
'folder_path',
'Folder_Path', 0);