use xide;
#------------------------------ Second volume: applications, pages ---------------------------------------------------------------------

#--ALTER TABLE pages ADD COLUMN ref_url varchar(100);
#--UPDATE pages SET ref_url = '';

#------------------------------ Tables creation ---------------------------------------------------------------------------------------- 

#-- This table stores information about applications created by users
CREATE TABLE applications (
	application_id 		int AUTO_INCREMENT,			#-- ID of the application
	application_title	varchar(200), 				#-- Title of the application (shown in the browser)
	description			text, 						#-- Application description
	author				varchar(100),				#-- Username of the application author
	url					varchar(200),				#-- URL where the application is published
	rel_url 			varchar(100), 				#-- Relative url for the application (modified by user)
	creation_date		timestamp, 					#-- Date of creation 
	modification_date	timestamp, 					#-- Date of last modification 
	publishing_date		timestamp, 					#-- Date of publishing (last publishing)
	is_public			boolean, 					#-- Shows should application be displayable in the search list (true if yes)
	status				boolean,					#-- Shows is application published (true) or not (false)
	folder_path 		varchar(500), 		       	#-- Path to the folder which contains files related to the application
	main_page 			int,						#-- ID of the page, which is used as a main page
	is_demo				boolean,					#-- Ondicates whether this applciation is a demo application (showed to everybody, cannot be edited)
	PRIMARY KEY (application_id)
);


#-- This table stores information about pages created by users. Each page belongs to one single application. 
CREATE TABLE pages (
	page_id 			int AUTO_INCREMENT ,			#-- ID of the page
	page_title			varchar(200), 					#-- Title of the page
	description			text, 							#-- Page description
	creation_date		timestamp, 						#-- Date of creation 
	modification_date	timestamp, 					    #-- Date of last modification 
	rel_url 			varchar(100), 					#-- Relative url for the page (modified by user)
	application_id 		int REFERENCES applications,	#-- Reference to the application the page belongs to
	PRIMARY KEY (page_id)
);

# ---------------------------- Data Load -----------------------------------------------------------------------------------------------
#-- There is no initial data load for these tables. 
#-- When some action in performed in XIDE (e.g. new application or page is created, application or page is deleted, etc.), 
#-- information is automatically updated.

#-- If there are some existing applicications or pages, which should be added to the database, please see the following example.

#------------------------------------- Data Load Example------------------------------------- 

#--INSERT INTO applications (application_title, description, author, url, rel_url,
#--creation_date, modification_date, publishing_date, is_public, status, folder_path) 
#--VALUES(
#--'Test Application',
#--'This is a test application',
#--'test_user',
#--'', '',
#--NOW(), 
#--0,
#--0,
#--true,
#--false,
#--'users/test_user/test_application');

#--INSERT INTO pages (page_title, description, creation_date, modification_date, rel_url, application_id) 
#--VALUES( 		
#--'Test Page',
#--'This is a test page',
#--NOW(), 
#--0,
#--'test_page',
#--*ID given to the application this page should be assigned to*);

