xquery version "1.0" encoding "UTF-8";
(: Retrieve the highest data ID attribute value of a data source :)


(: Declare external variables :)
declare variable $dataIdAttributeNamespaceURI as xs:string external;
declare variable $dataIdAttributeLocalName as xs:string external;
declare variable $dataIdAttributeValuePrefix as xs:string external;


(: Retrieve data ID attribute values :)
let $dataIdAttributeValue :=
	for $attribute in //@*
		where $attribute/local-name() = $dataIdAttributeLocalName and $attribute/namespace-uri() = $dataIdAttributeNamespaceURI
		return if ( string-length( $dataIdAttributeValuePrefix ) = 0 ) then
			<dataidattributevalue>{ string( $attribute ) }</dataidattributevalue>
		else
			<dataidattributevalue>{ replace( string( $attribute ), $dataIdAttributeValuePrefix, "" ) }</dataidattributevalue>


(: Return the result :)
return max( $dataIdAttributeValue )