% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

function sol_up = upsample(Data,sol,N)    

    W = 2;
    n = size(sol,1);
    %n=N*0.25;
    n_var = size(sol,3);
    
    Zlow = imresize(Data.Z, [n n], 'bilinear');
%    Zlow = imresize_sq(Data.Z, n);
    newsize = size(Data.Z);
    newsize(1:2) = [n n];
    Zlow = reshape(Zlow, newsize);    
    DClow = imresize(Data.DC, [n n], 'bilinear');
%    DClow = imresize_sq(Data.DC, n);
    %DClow = Data.DC(1:4:end,1:4:end,:);
    
    Zhi = imresize(Data.Z, [N N], 'bilinear');
    %Zhi = imresize_sq(Data.Z, N);
    newsize = size(Data.Z);
    newsize(1:2) = [N N];
    Zhi = reshape(Zhi, newsize);    
    DChi = imresize(Data.DC, [N N],'bilinear');
    %DChi = imresize_sq(Data.DC, N);

    sol_up = zeros(N,N, n_var);
    
    for I = 1:N
        for J = 1:N
            
            ii = (I-0.5) * ((n)/(N));
            jj = (J-0.5) * ((n)/(N));
            i = ceil(ii);
            j = ceil(jj);
            
            i0 = max(1,i-W);
            j0 = max(1,j-W);
            i1 = min(n,i+W);
            j1 = min(n,j+W);
            
            wx = i1-i0+1;
            wy = j1-j0+1;
            wn = wx*wy;
            
            %[i j i0 i1 j0 j1 ii jj]
%            return
           % imagesc(Data.DC(i0:i1,j0:j1,2));
            
            D = reshape(Zhi(I,J,2,:,:),[],1);
            D = double([DChi(I,J,2); real(D); imag(D)]);
            d = squeeze(Zlow(i0:i1,j0:j1,2,:,:));
            %D1 = squeeze(d(1,1,:,:))
            %d = permute(d, [3 4 1 2]);
            d = reshape(d, wn, []);
            
            v = squeeze(sol(i0:i1,j0:j1,1:n_var));
            v = reshape(v, wn, []);
            
            
            d = double([reshape(DClow(i0:i1,j0:j1,2),[],1) real(d) imag(d)]);
             weights = lsqnonneg([d.';10*ones(1,wn)],[D;10]);
            
            vnew = sum(v .* repmat(weights,[1 n_var]),1);
            
            sol_up(I,J,:) = vnew;
            %size(d)
            
        end
            if mod(I,5) == 1

                image(sqrt((sol_up(:,:,7)))*128)
                drawnow;
            end
    end
    
end