% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

function [img,w,h] = loadRAW(path, nz, rot)

imgo = imread(path);

nlizer = 2^12;
if nargin > 1
    nlizer = nz;
end

img = double(imgo) / nlizer;   % the raw data is 12 bits. XXX hardcoded for 5D Mk 2

if nargin == 3
    if rot == 1
        img = permute(img,[2 1 3]);
    end
end
h = size(img,2);
w = size(img,1);

end