% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

% Very naive Bayer interpolation (you should probably use dcraw's bayer
% instead...)
function cimg = bayer(img)

%img1 = loadRAW('c:\DATA\img_110203\CRW_6938.tiff');
%[r,g,b] = bayer(img1); imagesc(sqrt(g)); imagesc(max(0,-0.1+min(1,1.5*(sqrt(cat(3,r,0.8*g,b))))))

w = size(img,1);
h = size(img,2);

R = zeros(w,h,'single');
G = zeros(w,h,'single');
B = zeros(w,h,'single');

for j=1:2:h-2
    for i=1:2:w-2
        R(i,j) = img(i,j);
        R(i+1,j) = 0.5*(img(i,j)+img(i+2,j));
        R(i,j+1) = 0.5*(img(i,j)+img(i,j+2));
        R(i+1,j+1) = 0.5*(img(i,j)+img(i+2,j+2));
        
    end
end
for j=4:2:h
    for i=4:2:w
        B(i,j) = img(i,j);
        B(i-1,j) = 0.5*(img(i,j)+img(i-2,j));
        B(i,j-1) = 0.5*(img(i,j)+img(i,j-2));
        B(i-1,j-1) = 0.5*(img(i,j)+img(i-2,j-2));
    end
end
for j=2:h-1
    for i=3+mod(j,2):2:w-2
        G(i,j) = img(i,j);
        G(i+1,j) = 0.25*(img(i,j)+img(i+2,j)+img(i+1,j+1)+img(i+1,j-1));
    end
end

cimg = cat(3,R,G,B);
%R = circshift(R, [0 1]); % XXX
end
