/*
  (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
  University, University College London. This code is released under the 
  Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
  license (http://creativecommons.org/licenses/by-nc-sa/4.0/).
*/


#include "Task.hpp"

using namespace FW;

bool DisplayFrequencyTask::draw(FW::GLContext *gl, CanonState *camera)
{
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);

	float M_PI = 3.1415926;

	F32 posAttrib[] =
    {
		-1, -1, 0, 1,
		1, -1, 0, 1,
		-1, 1, 0, 1,
		1, 1, 0, 1
    };

    F32 texAttrib[] =
    {
		-M_PI, -M_PI/m_aspect,
		M_PI, -M_PI/m_aspect,
		-M_PI, M_PI/m_aspect,
		M_PI, M_PI/m_aspect
    };


    static const char* progId = "App::drawFrequencyQuad";
    GLContext::Program* prog = gl->getProgram(progId);
    if (!prog)
    {
        prog = new GLContext::Program(
            FW_GL_SHADER_SOURCE(
                attribute vec4 posAttrib;
                attribute vec2 texAttrib;
                varying vec2 W;
                void main()
                {
                    gl_Position = posAttrib;
                    W = texAttrib;
                }
            ),
            FW_GL_SHADER_SOURCE(
                uniform sampler2D texSampler;
                varying vec2 W;

				uniform vec2 frequency;
				uniform float phase;
				uniform vec2 window_covi;
				uniform float elapsed;
				uniform bool b_threshold;
				uniform float d_elapsed_inv;

                void main()
                {
//                    gl_FragColor = vec4(vec3(sin(W.s)*0.5+0.5>mod(threshold,1.0)), 1);
					float win = exp(-0.5 * dot(window_covi * W, window_covi * W));
					//float win = exp(-0.5 * dot(W, W));
					float val = win * sin(dot(frequency, W)+phase);

                    //gl_FragColor = vec4(vec3(sqrt(val)), 1);
					//gl_FragColor = vec4(vec3(val>elapsed), 1);
					if (elapsed > 0 && elapsed < 1)
					{
						if (!b_threshold)
							gl_FragColor = vec4(vec3((val-elapsed)*d_elapsed_inv), 1);
							//gl_FragColor = vec4(vec3(val>elapsed), 1);
						else
							gl_FragColor = vec4(vec3(pow(val,0.4545)), 1);
					}
					else
						gl_FragColor = vec4(0,0,0,1.0);
                }
            ));
        gl->setProgram(progId, prog);
    }

    prog->use();

    gl->setAttrib(prog->getAttribLoc("posAttrib"), 4, GL_FLOAT, 0, posAttrib);
    gl->setAttrib(prog->getAttribLoc("texAttrib"), 2, GL_FLOAT, 0, texAttrib);

	gl->setUniform(prog->getUniformLoc("frequency"), m_frequency);
	gl->setUniform(prog->getUniformLoc("phase"), m_phase);
	gl->setUniform(prog->getUniformLoc("window_covi"), m_window_stdi);

	gl->setUniform(prog->getUniformLoc("b_threshold"), m_threshold);

	gl->setUniform(prog->getUniformLoc("d_elapsed_inv"), m_exposure.exposure()*60.0f);

	if (!m_initialized)
	{
		m_exposure.start();
		m_initialized = true;
	}

	if (m_exposure.finished())
		return true;


	gl->setUniform(prog->getUniformLoc("elapsed"), m_exposure.elapsedNormalizedCut());

	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	return false;
}



bool DisplayCalibrationTask::draw(FW::GLContext *gl, CanonState *camera)
{
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);

	float M_PI = 3.1415926;

	F32 posAttrib[] =
    {
		-1, -1, 0, 1,
		1, -1, 0, 1,
		-1, 1, 0, 1,
		1, 1, 0, 1
    };

    F32 texAttrib[] =
    {
		-M_PI, -M_PI/m_aspect,
		M_PI, -M_PI/m_aspect,
		-M_PI, M_PI/m_aspect,
		M_PI, M_PI/m_aspect
    };


    static const char* progId = "App::drawCalibrationQuad";
    GLContext::Program* prog = gl->getProgram(progId);
    if (!prog)
    {
        prog = new GLContext::Program(
            FW_GL_SHADER_SOURCE(
                attribute vec4 posAttrib;
                attribute vec2 texAttrib;
                varying vec2 W;
                void main()
                {
                    gl_Position = posAttrib;
                    W = texAttrib;
                }
            ),
            FW_GL_SHADER_SOURCE(
                uniform sampler2D texSampler;
                varying vec2 W;

				uniform float intensity;
				uniform vec2 lowerLeft;
				uniform vec2 upperRight;
				uniform float elapsed;
				

                void main()
                {
					float val = 0;

					if (W.x > lowerLeft.x && W.x < upperRight.x)
						val += intensity * 0.5;

					if (W.y > lowerLeft.y && W.y < upperRight.y)
						val += intensity * 0.5;


					gl_FragColor = vec4(vec3(val), 1);
                }
            ));
        gl->setProgram(progId, prog);
    }

    prog->use();

    gl->setAttrib(prog->getAttribLoc("posAttrib"), 4, GL_FLOAT, 0, posAttrib);
    gl->setAttrib(prog->getAttribLoc("texAttrib"), 2, GL_FLOAT, 0, texAttrib);

	gl->setUniform(prog->getUniformLoc("intensity"), m_intensity);
	gl->setUniform(prog->getUniformLoc("lowerLeft"), m_lowerLeft);
	gl->setUniform(prog->getUniformLoc("upperRight"), m_upperRight);

	if (!m_initialized)
	{
		m_exposure.start();
		m_initialized = true;
	}

	gl->setUniform(prog->getUniformLoc("elapsed"), m_exposure.elapsedNormalizedCut());

	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	if (m_exposure.finished())
		return true;

	return false;
}




bool OpenShutterTask::draw(FW::GLContext *gl, CanonState *camera)
{
#ifdef USE_CAMERA_EVENTS
	EdsUInt32 val = 2;
	EdsSetPropertyData(camera->camera(), kEdsPropID_SaveTo, 0, sizeof(EdsUInt32), &val);

	EdsCapacity capacity;
	capacity.reset = 1;
	capacity.bytesPerSector = 512*8;
	capacity.numberOfFreeClusters = 36864*9999;
	EdsError err = EdsSetCapacity(camera->camera(), capacity);
#endif
	camera->shoot();

	// Always finish right away
	return true;
}



