/*
  (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
  University, University College London. This code is released under the 
  Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
  license (http://creativecommons.org/licenses/by-nc-sa/4.0/).
*/


#pragma once

#include "EDSDK.h"
#include "EDSDKTypes.h"
#include "EDSDKErrors.h"

#include <stdio.h>

class CanonState
{
public:
	CanonState() : m_camera(nullptr), m_isSDKLoaded(false) {};

	~CanonState() { close(); };

	EdsError setup();
	EdsError getFirstCamera(EdsCameraRef *camera);

	EdsError handleStateEvent(
						EdsUInt32			inEvent,
						EdsUInt32			inParam 
						)
	{
		printf("state event %i %i\n", inEvent, inParam);
		return EDS_ERR_OK;
	};

	EdsError handleObjectEvent( EdsObjectEvent inEvent,
									   EdsBaseRef inObject)
	{
		printf("object event %i\n", inEvent);

		if(inEvent == kEdsObjectEvent_DirItemRequestTransfer) {
			transferImage(inObject);
		}

		if(inObject)
		{
			EdsRelease(inObject);
		}

		return EDS_ERR_OK;
	}

	EdsError handlePropertyEvent (
						EdsUInt32			inEvent,
						EdsUInt32			inPropertyID,
						EdsUInt32			inParam)
	{
		printf("property event %i\n", inEvent);

		return EDS_ERR_OK;
	}


	EdsError shoot()
	{
		return EdsSendCommand(m_camera, kEdsCameraCommand_TakePicture , 0);
	}

	EdsError transferImage(EdsBaseRef object);

	void close();


	EdsCameraRef& camera() { return m_camera; };

	EdsCameraRef m_camera;
	bool m_isSDKLoaded;
};
