/*
  (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
  University, University College London. This code is released under the 
  Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
  license (http://creativecommons.org/licenses/by-nc-sa/4.0/).
*/

#pragma once
#include "gui/Window.hpp"
#include "gui/CommonControls.hpp"
#include "gui/Image.hpp"
#include "3d/CameraControls.hpp"
#include "gpu/Buffer.hpp"

#include <vector>
#include <deque>

#include "Task.hpp"

#include "Camera.hpp"

namespace FW
{
//------------------------------------------------------------------------




class App : public Window::Listener, public CommonControls::StateObject
{
private:
    enum Action
    {
        Action_None,
		Action_ReconnectCamera,
		Action_Shoot,
        Action_TestButton,
		Action_ShootExposure,
		Action_ShootCalibration,
		Action_ShootMarker,
		Action_ShootStandard

    };


public:
                    App             (void);
    virtual         ~App            (void);

    virtual bool    handleEvent     (const Window::Event& ev);
    virtual void    readState       (StateDump& d);
    virtual void    writeState      (StateDump& d) const;

private:
    void            waitKey         (void);
    void            renderFrame     (GLContext* gl);
    void            renderScene     (GLContext* gl, const Mat4f& worldToCamera, const Mat4f& projection);
    void            renderQuad      (GLContext* gl);

	static bool		fileExists		(const String& filenName);

	void			setupShaders	(GLContext* gl);

private:
                    App             (const App&); // forbidden
    App&            operator=       (const App&); // forbidden

private:
    Window          m_window;
    CommonControls  m_commonCtrl;
    CameraControls  m_cameraCtrl;

    Action          m_action;

	Timer								m_updateClock;
	Timer			m_timer;

	std::deque<Task*>	m_taskqueue;

	FW::Vec2f	m_calibRectLL;
	FW::Vec2f	m_calibRectUR;
	FW::Vec2f	m_windowMean;
	FW::Vec2f	m_windowStdi;
	float		m_exp;
	float		m_expPre;
	float		m_expPost;

	bool		m_threshold;
	float		m_windowSize;

	CanonState	m_canon;

	void queueDisplayProgram(FW::String fname);

	float getAspect() const
	{
		return (float)m_window.getSize().x / (float)m_window.getSize().y;
	}
};

//------------------------------------------------------------------------
}
