% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

function Data = whitebalance2(Data)
    wb = 1./squeeze(mean(mean(Data.DC),2));
    wb = wb/max(wb);
    
    Data.wb = wb;
    
    Data.DC = cat(3, wb(1)*Data.DC(:,:,1), wb(2)*Data.DC(:,:,2), wb(3)*Data.DC(:,:,3));

    for phi = 1:size(Data.Z,5)
        for f = 1:size(Data.Z,4)
        for c = 1:3
            Data.Z(:,:,c,f,phi) = Data.Z(:,:,c,f,phi) * wb(c);
    end
        end
    end
end