% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

function results_output(Data, sol, path)

    img_alb_d = sol(:,:,[1 3 4]);
    img_alb_s = sol(:,:,[2 5 6]);

    img_alb_d = img_alb_d * pi^2;
    
    scale = max([img_alb_d(:);img_alb_s(:)]);
    img_alb_d = img_alb_d / scale;
    img_alb_s = img_alb_s / scale;
    
    imwrite(uint16(img_alb_d*2^16), strcat(path,'alb_d.tiff'),'tiff');
    imwrite(uint16(img_alb_s*2^16), strcat(path,'alb_s.tiff'),'tiff');
 
    nx = squeeze(sol(:,:,8));
    ny = squeeze(sol(:,:,9));
    nscale = 1;
    N = cat(3,nx*nscale,ny*nscale,0*nx+1);
    N = N ./ repmat(sqrt(sum(N.^2,3)), [1 1 3]);
    N = max(0,min(1,0.5*(N+1)));

    imwrite(uint16(N*2^16), strcat(path,'normal.tiff'),'tiff');

    S = squeeze(sol(:,:,7));
    S = max(0,min(1,S));
        
    imwrite(uint16(S*2^16), strcat(path,'glossiness.tiff'),'tiff');
   
    K = sol(:,:,10)*0.01;
    imwrite(uint16(K*2^16), strcat(path,'kurtosis.tiff'),'tiff');


end