% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

function Mat = make_proj_transform_4(from, to)
        % The input is two 4x3 matrices, where the columns correspond to 
        % the four corner points in homogeneous coordinates.
        
        % Form a 8x8 matrix based on the input values.
        A = [ ...
            from(1,1) from(2,1) from(3,1) 0 0 0 -to(1,1)*from(1,1) -to(1,1)*from(2,1);
            0 0 0 from(1,1) from(2,1) from(3,1) -to(2,1)*from(1,1) -to(2,1)*from(2,1);
            from(1,2) from(2,2) from(3,2) 0 0 0 -to(1,2)*from(1,2) -to(1,2)*from(2,2);
            0 0 0 from(1,2) from(2,2) from(3,2) -to(2,2)*from(1,2) -to(2,2)*from(2,2);
            from(1,3) from(2,3) from(3,3) 0 0 0 -to(1,3)*from(1,3) -to(1,3)*from(2,3);
            0 0 0 from(1,3) from(2,3) from(3,3) -to(2,3)*from(1,3) -to(2,3)*from(2,3);
            from(1,4) from(2,4) from(3,4) 0 0 0 -to(1,4)*from(1,4) -to(1,4)*from(2,4);
            0 0 0 from(1,4) from(2,4) from(3,4) -to(2,4)*from(1,4) -to(2,4)*from(2,4);
            ];

        % Form a 8-vector from the flattened to-coordinates
        b = [to(1,1);
               to(2,1);
               to(1,2);
               to(2,2);
               to(1,3);
               to(2,3);
               to(1,4);
               to(2,4);
               ];

        % Solve A * X = b
        X = A \ b;
        
        % Rearrange the resulting values into a 3x3 matrix. This is the
        % result.
        Mat = [X(1) X(2) X(3);
               X(4) X(5) X(6);
               X(7) X(8) 1]
            
end    
