% (c) 2013-2015 Miika Aittala, Jaakko Lehtinen, Tim Weyrich, Aalto 
% University, University College London. This code is released under the 
% Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International 
% license (http://creativecommons.org/licenses/by-nc-sa/4.0/).

% You should probably say something like 'matlabpool 4' in the console 
% before running the optimizer, otherwise it's going to be very slow.

function calibration_ui

    global img;
    global roi_ul;
    global roi_size;
    global Data;
    global defaultPath;    
    
    
    defaultPath = '';
    
%    clear Data;
    img = zeros(100,150);
    
    if isstruct('Data') == 0
        Data = struct;
        Data.calib_done = 0;

        % Fill in some default stuff just for visual reference
        Data.p_screen = [0.5042 0.1678 1;
                    0.7208 0.1506 1;
                    0.6519 0.0446 1;
                    0.4088 0.0712 1;]';

        Data.p_refl =   [0.5727 0.4407 1;
                    0.7717 0.4382 1;
                    0.7683 0.6530 1;
                    0.5658 0.6459 1;]';

        Data.p_marker = [0.7403 0.3352 1;
                0.8702 0.4463 1;
                0.6142 0.5534 1;
                0.5148 0.4234 1;]';

        roi_ul = [0.1;1.5];
        roi_size = 1.1;

    end
    
	drawCalibrationInput;

end

function drawUI()
    bw = 100;
    bh = 20;
    bx = 10;
    by = 10;
    ox = 102;
    oy = 22;

    uicontrol('Style', 'pushbutton', 'String', 'Load data',...
    	'Position', [bx+0*ox by+3*oy bw bh],...
        'Callback', @h_loadData);

    uicontrol('Style', 'pushbutton', 'String', 'Save data',...
    	'Position', [bx+1*ox by+3*oy bw bh],...
        'Callback', @h_saveData);

    uicontrol('Style', 'pushbutton', 'String', 'Batch RAW',...
    	'Position', [bx+2*ox by+3*oy bw bh],...
        'Callback', @h_batchRAW);
    
    uicontrol('Style', 'pushbutton', 'String', 'Reflection image',...
    	'Position', [bx+0*ox by+2*oy bw bh],...
        'Callback', @h_loadBGImage);
    uicontrol('Style', 'pushbutton', 'String', 'Set screen',...
    	'Position', [bx+1*ox by+2*oy bw bh],...
        'Callback', @h_getMouseScreen);
    uicontrol('Style', 'pushbutton', 'String', 'Set reflection',...
    	'Position', [bx+2*ox by+2*oy bw bh],...
        'Callback', @h_getMouseReflection);
    uicontrol('Style', 'pushbutton', 'String', 'Marker image',...
    	'Position', [bx+3*ox by+2*oy bw bh],...
        'Callback', @h_loadBGImage);
    uicontrol('Style', 'pushbutton', 'String', 'Set marker',...
    	'Position', [bx+4*ox by+2*oy bw bh],...
        'Callback', @h_getMouseMarker);
    

    uicontrol('Style', 'pushbutton', 'String', 'Calibrate',...
    	'Position', [bx+0*ox by+1*oy bw bh],...
        'Callback', @h_runCalib);
    uicontrol('Style', 'pushbutton', 'String', 'Region image',...
    	'Position', [bx+1*ox by+1*oy bw bh],...
        'Callback', @h_loadBGImage);
    uicontrol('Style', 'pushbutton', 'String', 'Set region',...
    	'Position', [bx+2*ox by+1*oy bw bh],...
        'Callback', @h_getMouseROI);

    
     uicontrol('Style', 'pushbutton', 'String', 'Pre-process',...
    	'Position', [bx+0*ox by+0*oy bw bh],...
        'Callback', @h_constructData);

    uicontrol('Style', 'pushbutton', 'String', 'Solve (standard)',...
    	'Position', [bx+1*ox by+0*oy bw bh],...
        'Callback', @h_solve);

    uicontrol('Style', 'pushbutton', 'String', 'Solve (heuristic)',...
    	'Position', [bx+2*ox by+0*oy bw bh],...
        'Callback', @h_solve_heuristic);
end

function h_loadData(hObj,event)
    global Data;
    global defaultPath;
    
    [fname,dirname] = uigetfile('*.mat','Load data', defaultPath);
    defaultPath = dirname;

    load(strcat(dirname,fname));
    Data
    Data.path = dirname;
    Data.calib_done = 1;
	Data.mog_win{1}.sigma = 4*diag([1^2 0.5625^2]); % 16/9
    
    drawCalibrationInput();

end

function h_saveData(hObj,event)
    global Data;
    global defaultPath;
    
    [fname,dirname] = uigetfile('*.mat','Save data', defaultPath);
    defaultPath = dirname;

    save(strcat(dirname,fname), 'Data');
    
end

function h_solve_heuristic(hObj,event)
    global defaultPath;
    global Data;
    
    path_out = strcat(defaultPath, 'output\heuristic\');
    mkdir(strcat(defaultPath,'output'));
    mkdir(strcat(defaultPath,'output\heuristic'));
    
    nf = size(Data.Z,4) * size(Data.Z,5);
    datamax = max(max(abs(Data.DC(:))), max(abs(Data.Z(:))))

    imwrite(uint16((Data.DC/datamax)*2^16), strcat(path_out,'abs_',num2str(0,'%04i'),'.tiff'), 'tiff'); 
    for i = 1:nf
        imwrite(uint16((abs(Data.Z(:,:,:,i))/datamax)*2^16), strcat(path_out,'abs_',num2str(i,'%04i'),'.tiff'), 'tiff');    
        imwrite(uint16((angle(Data.Z(:,:,:,i))/2/pi+0.5)*2^16), strcat(path_out,'phase_',num2str(i,'%04i'),'_0.tiff'), 'tiff');    
        imwrite(uint16(((mod(angle(Data.Z(:,:,:,i)),2*pi)-pi)/2/pi+0.5)*2^16), strcat(path_out,'phase_',num2str(i,'%04i'),'_1.tiff'), 'tiff');    
    end
    
    
    nmap = heuristic_normals;
    imwrite(uint16((nmap*0.5+0.5)*2^16), strcat(path_out,'normals.tiff'), 'tiff');
    
    drawCalibrationInput();
    
end



function h_solve(hObj,event)
    global defaultPath;
    global Data;
    global sols;

    %matlabpool 4;
    
    path_out = strcat(defaultPath, 'output\');
    mkdir(strcat(defaultPath,'output'));
%    FNAME = strcat(path_out, 'sol_ui.mat')
    sols = optimizer(Data, path_out);
end

function drawCalibrationInput()
    global img;
    global Data;
    global roi_ul;
    global roi_size;
    stdaxis = [0 0 1;
               1 0 1;
               1 1 1;
               0 1 1]';
    clf;
    aspect = size(img,1)/size(img,2);
  %  imagesc([0 1], [0 aspect], img);
  axis([0 1 0 aspect]);
  axis ij;
    colormap gray;
    hold on;

    nlize_multi = @(x) x ./ repmat(x(end,:), [size(x,1) 1]);

    drawPoly(nlize_multi(Data.p_marker), 'm');
    drawPoly(nlize_multi(Data.p_screen), 'r');
    drawPoly(nlize_multi(Data.p_refl), 'b');

    
    Data
    if (Data.calib_done == 1)
        drawPoly(nlize_multi(Data.T_floor \ (Data.T_img_to_floor * stdaxis)),'c');
    end
    
    drawUI;
end

function drawPoly(points, style)
    n = size(points,2);
    plot([points(1,1) points(1,1)],[points(2,1) points(2,1)],'-ok')
    for i = 1:n
        next = mod(i,n)+1;
        curr = i;
        
        plot([points(1,curr) points(1,next)],[points(2,curr) points(2,next)], style);
    end
end

function h_batchRAW(hObj,event)
    global defaultPath;
    
    [fname,dirname] = uigetfile('*.cr2','Choose file from directory', defaultPath);
    defaultPath = dirname;

    fnames = strcat(dirname,'*.cr2');
    ff = dir(fnames)';

    batchRAW_exec(dirname, ff);
    
    drawCalibrationInput;
end

function batchRAW_exec(dirname, ff)
    i = 0;
    for f = ff(1:end)
        i = i + 1;
        fname = f.name;
        [temp, base] = fileparts(fname);
        dfname = strcat(dirname, base)
        %raw2tiff_cr2(dfname);
        disp(sprintf('%i of %i done.',i, numel(ff)));
        system(['dcrawms.exe -v -T -t 0 -D -4 ' dfname '.cr2']);

    end
end

%t = timer('TimerFcn','asdf=1234;','Period',1,'ExecutionMode','fixedDelay');


function h_getMouseScreen(hObj,event)
    global Data;
    points = ginput(4);
    Data.p_screen = [points [1;1;1;1]]';
    drawCalibrationInput;
end

function h_getMouseReflection(hObj,event)
    global Data;
    points = ginput(4);
    Data.p_refl = [points [1;1;1;1]]';
    drawCalibrationInput;
end

function h_getMouseMarker(hObj,event)
    global Data;
    points = ginput(4);
    Data.p_marker = [points [1;1;1;1]]';
    drawCalibrationInput;
end

function h_getMouseROI(hObj,event)
    global roi_ul;
    global roi_size;
    global Data;
    
    points = ginput(2);
    roi_scr = [points [1;1]]';
    nlize_multi = @(x) x ./ repmat(x(end,:), [size(x,1) 1]);
    roi = nlize_multi(Data.T_floor * roi_scr)
    
    roi_ul = roi(1:2,1)
    roi_size = max(0.01, mean(roi(1:2,2)-roi(1:2,1)));
    h_runCalib(0,0)
    drawCalibrationInput;
end


function h_loadBGImage(hObj,event)
    global img;
    global defaultPath;
    
    [fname,dirname] = uigetfile('*.tiff','Load image', defaultPath);
    defaultPath = dirname;
    
    %img = imread(strcat(dirname,fname));
    imgraw = loadRAW(strcat(dirname,fname),8192*1.5); % XXX constant based on whatever
    imgraw = bayer(imgraw);

    img2 = imgraw;
    img2 = img2 - min(img2(:));
    img2 = img2/max(img2(:));
    img = img2;

    
    drawCalibrationInput;
end

function h_runCalib(hObj,event)
    global img;
    global roi_ul;
    global roi_size;
    global Data;
    
%	Data = struct();
	Data.imgsize = [1024 1024];


    aspect = size(img,1)/size(img,2);
	Data.imgwin = [0 1 0 aspect];
    Data.aspect = aspect;
    
    Data.roi_floor = [roi_ul(1) roi_ul(2) 1;
                 roi_ul(1)+roi_size roi_ul(2) 1;
                 roi_ul(1)+roi_size roi_ul(2)+roi_size 1;
                 roi_ul(1) roi_ul(2)+roi_size 1;]';
    
    Data = calibrate(Data);
    

    Data.calib_done = 1;
end


function h_constructData(hObj,event)
    global Data;
    global defaultPath;
    
    nlize_multi = @(x) x ./ repmat(x(end,:), [size(x,1) 1]);
    
    % Fill in the window (XXX hardcoded!)
    mog_win{1}.mu = [0;0];
%        mog_win{1}.sigma = 4*diag([1^2 0.625^2]); % 16/10
	mog_win{1}.sigma = 4*diag([1^2 0.5625^2]); % 16/9, stdev 2 (note that the original paper datasets used stdev 1)
    mog_win{1}.mult = 1;
    Data.mog_win = mog_win;

    Data.freqs = [1, 2, 3, 4, 6, 10, 20, 40];%[1 2 3 4 5 6 8 12];
	Data.angles = [0 1/8 2/8 3/8] * 2 * pi;
%        Data.phases = [0 2/3*pi 4/3*pi];
	Data.phases = [-sqrt(-1) 1 sqrt(-1) -1];   % These are not actual phases, but multipliers for computation!

    % XXX Hardcoded monitor emission
    Data.mon.z_m = 12.7612;
    Data.mon.y_m = -0.0720;
	Data.mon.s_m = [0.7536;0.5928];
    
    [fname,dirname] = uigetfile('*.tiff','First file in the sequence (black image)', defaultPath)
    defaultPath = dirname;
    
    file_i = str2num(sscanf(fname, 'IMG_%c%c%c%c.tiff'));
    
    fileprefix = strcat(dirname, 'IMG_');
    filesuffix = '.tiff';
    
    blackfilename = strcat(strcat(fileprefix, ...
         sprintf('%04i', file_i)), filesuffix)
    img = loadRAW(blackfilename,8192*1.5);
    img = bayer(img);
    img_black = img;

    file_i = mod(file_i + 1,10000);

    dcfilename = strcat(strcat(fileprefix, ...
         sprintf('%04i', file_i)), filesuffix);
    img = loadRAW(dcfilename,8192*1.5);
    img = bayer(img);
    img = img - img_black;

    clear img_black;

    clf;

    imagec(img);

    aspect = size(img,1)/size(img,2);

    clear img_black;

    drawnow;

    bright = 1;
    roi_scr = nlize_multi(Data.T_floor \ Data.roi_floor);
    roi_scr = roi_scr(1:2,:)';

    udata = [0 1];  vdata = [0 aspect];
    tform = maketform('projective', roi_scr, [0 0; 1 0; 1 1; 0 1]);

    [img,xdata,ydata] = imtransform(img, tform, 'bilinear', ...
                                  'udata', udata,...
                                  'vdata', vdata,...
                                  'xdata',[0 1],...
                                  'ydata',[0 1],...
                                  'size', [3072 3072], ...%size(Data.DC),...
                                  'fill', 0.5);

    img = imresize(img,Data.imgsize,'bilinear');
    imagec(img)
    axis equal

    Data.DC = img;

    file_i = mod(file_i + 1,10000);

    n_f = numel(Data.freqs);
    n_phi = numel(Data.angles);
    n_p = numel(Data.phases);
    n_c = 3;
    Data.Z = zeros([Data.imgsize n_c n_f n_phi]);
%        Data.DC = zeros([Data.imgsize n_c n_f n_phi]);


    for phi = 1:numel(Data.angles)
        for f = 1:numel(Data.freqs)
            for p = 1:numel(Data.phases)
                filename = strcat(strcat(fileprefix, ...
                    sprintf('%04i', file_i)), filesuffix);
                img = loadRAW(filename,8192*1.5);
                img = bayer(img);

                [img,xdata,ydata] = imtransform(img, tform, 'bilinear', ...
                                              'udata', udata,...
                                              'vdata', vdata,...
                                              'xdata',[0 1],...
                                              'ydata',[0 1],...
                                              'size', [3072 3072], ...%size(Data.DC),...
                                              'fill', 0.5);

                img = imresize(img,Data.imgsize,'bilinear');

                Data.Z(:,:,:,f,phi) = Data.Z(:,:,:,f,phi) + Data.phases(p) * img;
                subplot(2,2,1);imagec(bright*img);axis equal;drawnow;

                file_i = file_i + 1;
                file_i = mod(file_i,10000);
            end
            subplot(2,2,3);
            imagec(bright*abs(Data.Z(:,:,:,f,phi)));
            axis equal
            subplot(2,2,4);
            imagec(angle(Data.Z(:,:,:,f,phi))/pi/2+0.5);
            axis equal
            drawnow;



        end
    end

    Data = whitebalance2(Data);
    Data.Z = single(Data.Z);

        
    save(strcat(dirname,'data.mat'),'Data');
        
    drawCalibrationInput;
        
end

