function R = IEEECalibrationGenerateData(fs,d,SRC,REC,inp)
%
% A.P. Southern
% Virtual Acoustics Team
% Department of Media Technology,
% Aalto University,
% Otaniemi,
% Espoo,
% Finland
% 47001
%
% d   = distance between source and receiver
% fs  = sampling rate 
% SRC = source position
% REC = list of receivers
% inp = amplitude of impulse ( default = 1 if not specified )

% Setup Constants
c = 344;                % speed of sound
dx = (sqrt(3)*c)/fs;    % internodal distance
T = round(fs*0.01111);  % duration of simulation in samples       

% Setup Pressure Field (5m x 5m x 5m)
L = round(5./dx);
W = round(5./dx);
H = round(5./dx);
p(L,W,H) = 0;           % setup an array on CPU
useCPU = 0;
try
    P1 = gpuArray(single(p));       % Initialize GPU array
    P2 = gpuArray(single(p));       % Initialize GPU array
    P1(1,1,1) = 1;          % check if indexing is allowed in the MATLAB release
catch
    warning('A MATLAB GPU Array could not be assigned, using CPU instead.');
    P1 = p;                 % Initialize CPU array
    P2 = p;                 % Initialize CPU array
    useCPU = 1;
end

% Load Decoupled Source for Transparent Source Implementation
load('h_ir_3D_1000.txt');

% Set Intial soft source condition
sx = SRC(1);
sy = SRC(2);
sz = SRC(3);
source(1:T) = 0;
source(1) = 1;
P1(sx,sy,sz) = source(1);
if ( exist('inp') == 1 )
    source(1) = source(1)*inp;
    P1(sx,sy,sz) = source(1);
    h_ir_3D_1000 = h_ir_3D_1000*inp; % scale decoupled source    
end

% Initialize Receiver Data
[numRec, t_dim] = size(REC);
R(1:numRec,1:T) = 0;
if useCPU == 0
    % Put onto GPU if using
    R = gpuArray(single(R));
end

% Pre-calculate 1D indices for receivers
idx = 1:(L*W*H);
IDX = reshape(idx,L,W,H);
for k = 1:numRec
    r_i(k) = IDX(REC(k,1),REC(k,2),REC(k,3));
end

% Setup Indices
i = 2:L-1; 
j = 2:W-1; 
k = 2:H-1;

figure;

% Propagate Source
for t = 2:T
    P2(i,j,k) = (1/3).*( P1(i+1,j,k)+...
                      P1(i-1,j,k)+...
                      P1(i,j+1,k)+...
                      P1(i,j-1,k)+...
                      P1(i,j,k+1)+...
                      P1(i,j,k-1)) - P2(i,j,k);
    
    % Apply Transparent Source
    acc = 0.0;
    for w=1:t
        if (t <= length(h_ir_3D_1000)) % Check that t is less than length of compensating IR
            acc = acc + h_ir_3D_1000(t-w+1)*source(w);
        else
            acc = acc;
        end                            
    end
    P2(sx,sy,sz) = P2(sx,sy,sz) + source(t)- acc;
    
    % Get Receiver Samples
    R(:,t) = P2(r_i);    
   
%     imagesc(double(P2(:,:,round(H/2))),[-0.001 0.001]);
%     axis equal
%     drawnow;
    
    tmp = P1;
    P1 = P2;
    P2 = tmp;
end

imagesc(double(P2(:,:,round(H/2))),[-0.001 0.001]);
hold on;
plot3(sy,sx,sz,'.k');
plot3(REC(:,2),REC(:,1),REC(:,3),'.k');
hold off;
axis equal

function r = isOdd(x)
if mod(x,2) == 0
  r = 0; %is even
else
  r = 1; %is odd
end