function BTART = IEEE_organizeBTARTdata
%
% This file loads the BT-ART data, finds the longest signal and pads all
% other responses with zeros to have the same length. The original wav file is
% overwritten. note that there is no rc = 0.0 response for BT-ART.
% By A Southern 2012.

IEEE_datasetDefinition;
rcstr(1:11) = {'00','10','20','30','40','50','60','70','80','90','99'};

% Find longest length
len = 0;
for s = 1:5
    for r = 1:5
        
        for rc = 2:11

            fn = ['A' rcstr{rc} 'R' num2str(s) 'S' num2str(r) '.wav'];
            [tmp fs] = wavread([D_CUBOID_BTART fn]);
            
            if length(tmp) > len
                len = length(tmp);
            end

        end   
        
    end
end

% Open wavs zero pad to len and then save only the W channel 
for s = 1:5
    for r = 1:5
        
        for rc = 2:11

            fn = ['A' rcstr{rc} 'R' num2str(s) 'S' num2str(r) '.wav'];
            [tmp fs] = wavread([D_CUBOID_BTART fn]);
            
            if length(tmp) < len
                w = zeros(len,1);
                w(1:length(tmp)) = tmp(:,1);
            end
            
            wavwrite(w,fs,[D_CUBOID_BTART fn]);

        end   
        
    end
end