function IEEE_getAcousticParamsData( ACOUSTICPARAMS  )

if exist( ACOUSTICPARAMS ) == 0        

    % Acoustic parameter variables
    vars.params = {'C50','C80','CT','EDT','T30'};
    vars.plot = 'none';
    vars.outputOrientation = 'band';
    vars.bands = {'1000'};
    vars.signaltype = {'modelled'};
    
    % Generate Reflection Coefficients
    R = -1:0.1:1;
    R(1) = R(1)+0.001;
    R(end) = R(end)-0.001;
    R = R(11:21);

    % Define Room Dimensions used
    dx = (344*sqrt(3))/18000; % internodal distance
    L = 5.59413920826801-dx;
    W = 4.00527126745816-dx;
    H = 2.84672172728431-dx;
    
     % Compensate 2D Responses to behave more like 3D as in
     % Temporal matching of 2D and 3D wavebased acoustic modeling for efficient and realistic simulation of rooms.
     % Jeremy J. Wells,, Damian T. Murphy, and Mark J. Beeson
     % Presented at the AES 126th Convention 2009 May 710 Munich, Germany
            
     [RT603d,MFP3d] = NorrisEyringCalc3D(round([L/dx,W/dx,H/dx]),18000,R);
     [RT602d,MFP2d] = NorrisEyringCalc2D(round([L/dx,W/dx]),18000,R);
     [gc,delta_g] = RT60compensate(RT602d,RT603d,18000);
            
     gc( delta_g > 0,: ) = 1;

    % Get RIR data and calculate Acoustic Parameters
    display(['Calculating acoustic parameters for 5 Sources and 5 Receviers (25 Combinations)']);
    display(['for 2-D FDTD, 3-D FDTD, ISM and BT-ART ...']);
    for s = 1:5
        for r = 1:5
            display(['Processing for Source ' num2str(s) ' and Receiver ' num2str(r) '...']);
            
            rirs = IEEE_RIRdata2array(2,'FDTD2D',s,r);
            vars.fs = 18000;
            
            [t_FDTD2D_NOCOMP row col] = acousticParams(rirs(11:21,:),vars);
            FDTD2D_NOCOMP{s,r} = t_FDTD2D_NOCOMP; 
            
            % apply compensationfor 2d
            rirs(11:21,:) = rirs(11:21,:).*gc(:,1:length(rirs));
            [t_FDTD2D row col] = acousticParams(rirs(11:21,:),vars);
            FDTD2D{s,r} = t_FDTD2D;            
            
            rirs = IEEE_RIRdata2array(2,'FDTD3D',s,r);
            vars.fs = 18000;
            [t_FDTD row col] = acousticParams(rirs(11:21,:),vars);
            FDTD{s,r} = t_FDTD;

            rirs = IEEE_RIRdata2array(2,'ISMP',s,r);
            vars.fs = 48000;
            [t_ISM row col] = acousticParams(rirs(11:21,:),vars);
            ISM{s,r} = t_ISM;
            
            rirs = IEEE_RIRdata2array(2,'BTART',s,r);
            vars.fs = 48000;
            [t_BTART row col] = acousticParams(rirs(1:end,:),vars);  
            BTART{s,r} = t_BTART;
        end
    end

    display(['Saving Acoustic Parameter Dataset to:']);
    display( ACOUSTICPARAMS );
    save ( ACOUSTICPARAMS, 'FDTD2D_NOCOMP','FDTD2D','FDTD','ISM','BTART' );

else
    
    display(['A previously computed acoustic parameter dataset exists and will therefore not be calculated again.']);
    display(['Exists at: ' ACOUSTICPARAMS]); 
   
end