function RIRS = IEEE_applyLowPass(RIRS,doNotFilter)

if isstruct(RIRS) == 1
    root = 'RIRS.';
    models = fieldnames(RIRS);

    % get receiver signals and apply filter
    for i = 1:length(models)

        applyFilter = true;
        if exist ( 'doNotFilter' ) == 1
           for f = 1:length(doNotFilter)
              if strcmp(doNotFilter{f},models{i}) == 1
                  applyFilter = false;
              end
           end
        end

        if applyFilter == true
            eval(['srcNames = fieldnames(RIRS.' models{i} ');']);
            numSrc = length(srcNames);

            for s = 1:numSrc
                for r = 1:21
                    eval(['sig = ' root models{i} '.' srcNames{s} '.R' num2str(r) ';']);
                    [numRec tmp] = size(sig);
                    nsig = zeros(numRec,tmp);
                    for k = 1:numRec
                        nsig(k,:) = filter(getlpf(),1,sig(k,:));                    
                    end
                    eval([root models{i} '.S' num2str(s) '.R' num2str(r) '=  nsig;']);
                end
            end
        end
    end
else
    [numRIRs numSamp] = size(RIRS);
    if numRIRs > numSamp
        warning('There are more RIRs than samples.');
    end
    
    lpf = getlpf();
    
    for i = 1:numRIRs
        rirs(i,:) = filter(lpf,1,RIRS(i,:));        
    end
    
    RIRS = rirs;
    
end

function lpf = getlpf()
lpf = [-0.00196366224306242,0.0123207409924145,0.0132465433315828,-0.00640357637612213,0.00468444815798063,-0.00221884007332293,-0.000454486571370301,0.00331634351858951,-0.00596313012536446,0.00782157526572944,-0.00830885626033654,0.00699575020467151,-0.00376919686050548,-0.00107051228151655,0.00679150211082488,-0.0122838671030833,0.0162303050593489,-0.0173896691535066,0.0148682157901187,-0.00826135390847113,-0.00201225827472375,0.0147072028658878,-0.0278374104720546,0.0387269327076170,-0.0444334718373824,0.0417784623027887,-0.0274906168224353,-0.00264674455465760,0.0571802305261647,-0.167072445552158,0.621043330627880,0.621043330627880,-0.167072445552158,0.0571802305261647,-0.00264674455465760,-0.0274906168224353,0.0417784623027887,-0.0444334718373824,0.0387269327076170,-0.0278374104720546,0.0147072028658878,-0.00201225827472375,-0.00826135390847113,0.0148682157901187,-0.0173896691535066,0.0162303050593489,-0.0122838671030833,0.00679150211082488,-0.00107051228151655,-0.00376919686050548,0.00699575020467151,-0.00830885626033654,0.00782157526572944,-0.00596313012536446,0.00331634351858951,-0.000454486571370301,-0.00221884007332293,0.00468444815798063,-0.00640357637612213,0.0132465433315828,0.0123207409924145,-0.00196366224306242;];
