function RIRS = IEEE_applyDCremoval(RIRS,doNotFilter)

if isstruct(RIRS) == 1
    root = 'RIRS.';
    models = fieldnames(RIRS);

    % get receiver signals and apply filter
    for i = 1:length(models)

        applyFilter = true;
        if exist ( 'doNotFilter' ) == 1
           for f = 1:length(doNotFilter)
              if strcmp(doNotFilter{f},models{i}) == 1
                  applyFilter = false;
              end
           end
        end

        if applyFilter == true
            for s = 1:5
                for r = 1:21
                        eval(['sig = ' root models{i} '.S' num2str(s) '.R' num2str(r) ';']);
                        [numRec tmp] = size(sig);
                        nsig = zeros(numRec,tmp);
                        for k = 1:numRec
                            nsig(k,:) = sosfilt(getsos(),double(sig(k,:)));                    
                        end
                        eval([root models{i} '.S' num2str(s) '.R' num2str(r) '=  nsig;']);
                end
            end
        end
    end
else
    [numRIRs numSamp] = size(RIRS);
    if numRIRs > numSamp
        warning('There are more RIRs than samples.');
    end
    
    SOS = getsos();
    
    for i = 1:numRIRs
        rirs(i,:) = sosfilt(SOS,RIRS(i,:));        
    end
    
    RIRS = rirs;
    
end

function SOS = getsos()
SOS = [1,-2,1,1,-1.99484056681628,0.994908606609834;1,-2,1,1,-1.98665747742862,0.986725238114298;1,-1,0,1,-0.991774753536618,0;];

