function rirs = IEEE_RIRdata2array(dataset_id,model,S,R)
% This function is not used as part of the main
% IEEE_ProcessArticleResults.m and its dependents. It is provided to allow
% the user to extract multiples RIRs from a dataset.
% The input dataset can either be dataset_id;
%     1) FDTD3D and ISMP - raw data stored in rt60dataset.mat
%     2) FDTD3D ISMP ART BTART - the filtered and merged dataset PP_CuboidData.mat
%     3) BTART
%   model = 'FDTD','ISMP,'BTART'

% Dataset Location Definition
IEEE_datasetDefinition;

switch dataset_id
    case 1
        if strcmp(model,'FDTD3D') == 1 || strcmp(model,'ISMP') == 1 || strcmp(model,'FDTD2D') == 1
            rirs = FDTDISM2array(D_CUBOID_FDTD_ISM,model,S,R);
        else
            error(['The specified model, ' model ', does not exist in the FDTD-ISM raw dataset.']);
        end   
    case 2
        if strcmp(model,'FDTD2D') == 1 || strcmp(model,'FDTD3D') == 1 || strcmp(model,'ISM') == 1 || strcmp(model,'ISMP') == 1 || strcmp(model,'BTART') == 1
            
            % Load the raw data and filter it.
            if strcmp(model,'FDTD2D') == 1 || strcmp(model,'FDTD3D') == 1 || strcmp(model,'ISMP') == 1 || strcmp(model,'ISM') == 1
                rirs = FDTDISM2array(D_CUBOID_FDTD_ISM,model,S,R);
            else
                rirs = btart2array(D_CUBOID_BTART,model,S,R);
            end
            
            rirs = IEEE_applyLowPass(double(rirs));
            rirs = IEEE_applyDCremoval(double(rirs));
            
        else
            error(['The specified model, ' model ', does not exist in the ART raw dataset.']);
        end        
    case 3
        if strcmp(model,'BTART') == 1
            rirs = btart2array(D_CUBOID_BTART,model,S,R);
        else
            error(['The specified model, ' model ', does not exist in the ART raw dataset.']);
        end
       
end        

function rirs = btart2array(btartfp,model,S,R)

if sum(S == [1 2 3 4 5]) == 1 && sum(R == [1 2 3 4 5]) == 1
    
    rcstr(1:11) = {'00','10','20','30','40','50','60','70','80','90','99'};
    
    [tmp fs] = wavread([btartfp 'A10R1S1.wav']);
    len = length(tmp);
    rirs = zeros(11,len);
    
    for rc = 2:11
                
        fn = ['A' rcstr{rc} 'R' num2str(R) 'S' num2str(S) '.wav'];
        [tmp fs] = wavread([btartfp fn]);

        rirs(rc,:) = tmp(:,1);
    end    

else
    error('The requested source receiver combination does not exist for BT-ART');
end

function rirs = art2array(artfp,S,R)

% Existing Source Receiver Combinations
SR_COMB(1,:) = [1 1]; % src 1 rec 1
[numComb t] = size(SR_COMB);

combinationExist = false;
for i = 1:numComb
    if S == SR_COMB(i,1) && R == SR_COMB(i,2)
        combinationExist = true;
    end
end

if combinationExist == true;
    rcstr(1:11) = {'00','10','20','30','40','50','60','70','80','90','99'};

    [tmp fs] = wavread([artfp 'A00R1S1.wav']);
    len = length(tmp);
    rirs = zeros(11,len);
    
    for rc = 1:11
        fn = ['A' rcstr{rc} 'R' num2str(R) 'S' num2str(S) '.wav'];
        [tmp fs] = wavread([artfp fn]);
        rirs(rc,:) = tmp(:,1);
    end    

else
    error('The requested source receiver combination does not exist for ART');
end

function rirs = FDTDISM2array(D_CUBOID_FDTD_ISM,model,S,R)

load( D_CUBOID_FDTD_ISM );
root = 'RIRS.';

if sum(S == [1 2 3 4 5]) == 1 && sum(R == [1 2 3 4 5]) == 1
    
    for r = 1:21
        eval(['sig = ' root model '.S' num2str(S) '.R' num2str(r) '(' num2str(R) ',:);']);
        rirs(r,:) = sig;           
    end 
    
else
    error('The specified source receiver combination does not exist in the FDTD-ISM raw dataset.');   
end