if exist( PPD_MERGED ) == 0    
    
    % Load 3DFDTD and ISMP dataset consiting of an RIR for every combination 
    % of 5 sources and 5 receivers for 21 reflection coefficients ranging
    % from [-0.99, -0.9 -0.8 ... 0.8 0.9 0.99].
    % Run IEEE_roomSetup.m to plot the cuboid room and the source/receiver
    % positions. The dataset is stored in a structure called RIRS.
    load( D_CUBOID_FDTD_ISM );

    % Load ART dataset consiting of RIR for every combination 
    % of (source 1 and receiver 1) ans (source 2 aned receiver 5) for 
    % 21 reflection coefficients ranging from 
    % [0 0.1,...,0.8 0.9 0.99]. Note that as ART is an energy based method
    % there is no meaning to negative reflection coefficients.
    RIRS.ART = IEEE_loadARTdata( D_CUBOID_ART );   
    
    % These filters are required for post-processing the FDTD data
    % They are applied to the ART and ISM data as well, in order to
    % keep the changes constant across the dataset.
    % Both filter functions accept a second parameter, a cell string array
    % which indicates data not to filter. This may be used to investigate
    % the effects of not applying the filtering to some of the dataset.
    % RIRS = IEEE_applyLowPass(RIRS,{'ART','ISMP'}); 
    RIRS = IEEE_applyLowPass(RIRS,{'ART','ISMP'});          
    RIRS = IEEE_applyDCremoval(RIRS,{'ART','ISMP'});
    
    save(PPD_MERGED,'RIRS');
else
    load(PPD_MERGED);
end
