function IEEE_Modal_Plot_PDF( RIRS )

% Raw Dataset Locations
IEEE_datasetDefinition

% PLOT FIGURE 5 from RIRS dataset (load the raw dataset)
load( D_CUBOID_FDTD_ISM );

fig = figure;hold on;

%---- Plot Signals of Interest -----
    SN = 1:5; % source number
    RN = 1:5; % receiver number
    R = -1:0.1:1; R(1) = -0.999; R(end) = 0.999;    
    RC(1,:) = [21 20 19]; % reflection coefficients Fig1
    RC(2,:) = [1 2 3]; % reflection coefficients Fig2
    
    % colors RGB
    %C(1,:) = [249 210 174]; % 86% Lum
    %C(2,:) = [109 185 248]; % 72% Lum
    C(1,:) = [1 0 0];       
    C(2,:) = [0 0 1];       
    C(3,:) = [0 0 0];       % 0% Lum    
    %C = C./255; %normalize
    
    % linewidth
    lw = [1 1 1];
    
    MODEL1 = 'ISMP';
    FS_1 = 48000;
    eta1 = 1;
    
    MODEL2 = 'FDTD3D';
    FS_2 = 18000;
    eta2 = 94;    % empirical calibration parameter
%------------------------

N1 = 48000*2;
N2 = 48000*2;

% Get Modes of Geometry
dx = (344*sqrt(3))/18000;

first = true;
Rstr = ''; % figure labelling
for si = 1:length(SN) % all sources
    for ri = 1:length(RN) % all recievers
        
        figure(fig);
        clf;

        for fh = 1:2; %+ve and -ve plots
            for ir = 1:length(RC(fh,:)) % each reflection coefficient       

                subplot(2,1,fh); 
                hold on;        
                plotModes(fig,dx,fh);

                eval(['sig = RIRS.' MODEL1 '.S' num2str(SN(si)) '.R' num2str(RC(fh,ir)) '(' num2str(RN(ri)) ',:).*eta1;']);
                sig1 = taperise(sig);

                eval(['sig = RIRS.' MODEL2 '.S' num2str(SN(si)) '.R' num2str(RC(fh,ir)) '(' num2str(RN(ri)) ',:).*eta2;']);
                sig2 = taperise(sig);

                SIG1 = abs(fft(sig1,N1));
                SIG2 = abs(fft(sig2,N2));

                fP1 = (( 1:length(SIG1)).* FS_1 ) / N1; 
                fP2 = (( 1:length(SIG2)).* FS_2 ) / N2; 

                p1 = plot(fP1,20.*log10(SIG1),'k');
                hold on;
                p2 = plot(fP2,20.*log10(SIG2),'--k');

                set(p1,'LineWidth',lw(ir));
                set(p1,'Color',C(ir,:));

                set(p2,'LineWidth',lw(ir));
                set(p2,'Color',C(ir,:));      
                
                Rstr = [Rstr num2str(R(RC(fh,ir))) ', '];
            end
            xlim([0 120]);
            ylim([-85 40]);
            set(gcf,'Position', [102   133   810   582]);

            title(gca,['Source ' num2str(SN(si)) ' and Receiver ' num2str(RN(ri))]);
            text(5, -60, ['R = ' Rstr(1:end-2)]);
            text(5, -72, ['FDTD = Dashed, ISM = Solid']);
            Rstr = ''; % reset label
            ylabel('Magnitude(dB)');  
        end
        xlabel('Frequency (Hz)');

        if first == true
            first = false;
            print ( '-dpsc2', 'IEEEmodalPDF.eps', gcf );
        else
            print ( '-dpsc2', 'IEEEmodalPDF.eps', '-append', gcf );
        end
    
    end
end
    
function plotModes(fig,dx,fh)

    figure(fig);

    [ax ta ob all] = roommodescalc(5.59413920826801-dx,4.00527126745816-dx,2.84672172728431-dx,344);
    % ---- Mark Modes -----
    if fh == 1    
        for n = 1:length(ax)
           h = plot([ax(n),ax(n)],[200 -200],'k'); 
           set(h,'LineWidth',0.2);
           set(h,'Color',[0.6 0.6 0.6]);
        end
        for n = 1:length(ta)
           h = plot([ta(n),ta(n)],[200 -200],'k');
           set(h,'LineWidth',0.2);
           set(h,'Color',[0.6 0.6 0.6]);
        end
    end
    for n = 1:length(ob)
       h = plot([ob(n),ob(n)],[200 -200],'k'); 
       set(h,'LineWidth',0.2);
       set(h,'Color',[0.6 0.6 0.6]);
    end
    % -----------------------


