function IEEE_FIG_10_RT60values( ACOUSTICPARAMS )

load ( ACOUSTICPARAMS );  

% Single Source Receiver Pair of Interest
SR = [1 1]; %src = 1, rec = 1
display(['The chosen single source/receiver combination is Source ' num2str(SR(1)) ' Receiver ' num2str(SR(2))]);

% Generate Reflection Coefficients
R = -1:0.1:1;
R(1) = R(1)+0.001;
R(end) = R(end)-0.001;
R = R(11:21);

% Define Room Dimensions used
dx = (344*sqrt(3))/18000; % internodal distance
L = 5.59413920826801-dx;
W = 4.00527126745816-dx;
H = 2.84672172728431-dx;
V = L*W*H; %volume
S = (2*L*W) + (2*W*H) + (2*W*H) + (2*L*H); %surface area

% Compute Sabine and NorrisEyring RT60 Predictions
rR = normal2randomIncidence(R);
SABINE = CalcSabineRT60(V,S,rR);
EYRING = CalcEyringRT60(V,S,rR);

% Compute RT60 for the single combination for all reflection coeffs
figure;
hold on;
plot(R,SABINE,':k');
plot(R,EYRING,':k');
h(1) = plot(R,BTART{SR(1),SR(2)}(5,:),'-g');
h(2) = plot(R,FDTD{SR(1),SR(2)}(5,:),'-k');
h(3) = plot(R,FDTD2D{SR(1),SR(2)}(5,:),'-k');
h(4) = plot(R,FDTD2D_NOCOMP{SR(1),SR(2)}(5,:),'-k');
h(5) = plot(R,ISM{SR(1),SR(2)}(5,:),'-');
xlim([0 0.9]);
ylim([0 0.53]);
legend(h,{'BT-ART','FDTD-3D','FDTD-2D','FDTD-2D-NC','ISM'},'Location','NorthWest');
title(['RT60 (T30) for a Source ' num2str(SR(1)) ' & Receiver ' num2str(SR(2))]);
xlabel('Reflection Coefficient');
ylabel('T30 (Seconds)');
clear h

% Compute Maen RT60 for over all 25 combinations for all reflection coeffs
figure;
hold on;
plot(R,SABINE,':k');
plot(R,EYRING,':k');

t_meanBTART = zeros(25,11);
t_meanFDTD = zeros(25,11);
t_meanFDTD2D = zeros(25,11);
t_meanFDTD2D_NOCOMP = zeros(25,11);
t_meanISM = zeros(25,11);
i = 1;
for s = 1:5
    for r = 1:5
        t_meanBTART(i,:) = BTART{s,r}(5,:);
        t_meanFDTD2D(i,:) = FDTD2D{s,r}(5,:);
        t_meanFDTD2D_NOCOMP(i,:) = FDTD2D_NOCOMP{s,r}(5,:);
        t_meanFDTD(i,:) = FDTD{s,r}(5,:);
        t_meanISM(i,:) = ISM{s,r}(5,:);
        i = i + 1;
    end
end

% omit 12,13,14,15 from BTART (error in computation) 
id = [1 2 3 4 5 6 7 8 9 10 11 16 17 18 19 20 21 22 23 24 25];

meanBTART = mean(t_meanBTART(id,:));
meanFDTD2D = mean(t_meanFDTD2D);
meanFDTD2D_NOCOMP = mean(t_meanFDTD2D_NOCOMP);
meanFDTD = mean(t_meanFDTD);
meanISM = mean(t_meanISM);

h(1) = plot(R,meanBTART,'.-g');
h(2) = plot(R,meanFDTD2D,'-k');
h(3) = plot(R,meanFDTD2D_NOCOMP,'-k');
h(4) = plot(R,meanFDTD,'-k');
h(5) = plot(R,meanISM,'-');

% Plot JND bars
JNDT30(1,:) = meanFDTD;
JNDT30(2,:) = meanISM;
%JNDT30(3,:) = BTART(5,:);
[mT30] = mean(JNDT30);

for i = 1:length(R);
    tp = mT30(i)*0.1; % 10 percent value
    ptsy = linspace(mT30(i)-(3*tp),mT30(i)+(3*tp),7); % -30 -20 -10 0 10 20 30
    ptsx(1:7) = R(i);  
    plot(ptsx,ptsy,'-r');
end

xlim([0 0.9]);
ylim([0 0.53]);
legend(h,{'BT-ART','FDTD2D','FDTD2D-NC','FDTD','ISM'},'Location','NorthWest');
title(['Mean RT60 (T30) for over 25 Source and Receiver Combinations']);
xlabel('Reflection Coefficient');
ylabel('T30 (Seconds)');