function [SRC REC] = IEEECalibrationModelSetup(fs,d)

dx = (sqrt(3)*344)./fs; %internodal distance

% test volume dimension in metres
L = 5;
W = 5;
H = 5;

% source position in metres
SRC = [2.4 2.4 2.5];

% receiver position definition
el = (0:90)*pi/180;
[rx ry rz] = sph2cart(45*pi/180,el,d);

REC(:,1) = rx+SRC(1);
REC(:,2) = ry+SRC(2);
REC(:,3) = rz+SRC(3);    

% Quantize receivers to grid
SRCq = round(SRC./dx);
SRCq = SRCq.*dx;
RECq = round(REC./dx);
RECq = RECq.*dx;

% Calc node Positions
[X Y] = meshgrid(0:dx:1,0:dx:1);
GRID(:,1) = X(:) + SRCq(1);
GRID(:,2) = Y(:) + SRCq(2);
GRID(:,3) = SRCq(3);    

% draw setup
figure;
plot3(GRID(:,1),GRID(:,2),GRID(:,3),'.k');
hold on;
plot3(SRCq(:,1),SRCq(:,2),SRCq(:,3),'or');
hold on;
plot3(RECq(:,1),RECq(:,2),RECq(:,3),'ob');
hold off;
title([num2str(fs) ' Hz']);
box on
axis equal
xlim([0 L]);
ylim([0 W]);
zlim([0 H]);    

% get only unique receiver positions
RECq = unique(RECq,'rows');

% convert quantized src/rec back to nodes
SRC = round(SRCq./dx);
REC = round(RECq./dx);
    
