function IEEE_ProcessArticleResults

choice = menu('Please select which part of the article you would like to run:',...
    'Equation 5 Calibration Parameter Linear Fit',...
    'Table 1',...
    'Figure 3 - Calibration parameter maximum error set',...
    'Table 2 - Source & Receiver setup',...
    'Figure 5 - Modal Response',...
    'Figure 7 - Joined Cuboid Impulse Response on GPU (with Animation)',...
    'Figure 7 - " on GPU (without Animation)',...
    'Figure 7 - " on CPU (with Animation)',...
    'Figure 7 - " on CPU (without Animation)',...
    'Figure 10 - RT60 comparison',...
    'Table 3 - Acoustic parameter comparison');

% Raw Dataset Locations
IEEE_datasetDefinition 

switch choice
%%%%%%% SECTION IV A - DEFINING THE CALIBRATION PARAMETER %%%%%%%

    case 1
        % CALCULATE LINEAR FIT - EQUATION 5
        IEEEHybridCalibrationMain(0);
    case 2
        % PRODUCE TABLE 1
        IEEEHybridCalibrationMain(1);
    case 3
        % PLOT FIG 3
        IEEEHybridCalibrationMain(2);

%%%%%%% SECTION V A - REFLECTION FROM A SINGLE SURFACE %%%%%%%


%%%%%%% SECTION V B - MODAL ANALYSIS IN A CUBOID ROOM %%%%%%%
    case 4
        % Show Model Setup (used to make TABLE 2)
        IEEE_roomSetup;
    case 5
        % PLOT FIGURE 5 from RIRS dataset (load the raw dataset)
        load( D_CUBOID_FDTD_ISM );
        IEEE_FIG_5_Modal_Plot( RIRS );

%%%%%%% SECTION V C - JOINED CUBOIDS MODEL %%%%%%%

    case 6
        % PLOT FIGURE 7
        savdir = cd; 
        cd(D_JOINEDCUBES);
        ir = IEEE_runFDTDgpuDoubleCube('visuals',true,'useGPU',true); %faster without visuals
        cd(savdir);
    case 7
        % PLOT FIGURE 7
        savdir = cd; 
        cd(D_JOINEDCUBES);
        ir = IEEE_runFDTDgpuDoubleCube('visuals',false,'useGPU',true); 
        cd(savdir);
    case 8
        % PLOT FIGURE 7
        savdir = cd; 
        cd(D_JOINEDCUBES);
        ir = IEEE_runFDTDgpuDoubleCube('visuals',true,'useGPU',false); %faster without visuals
        cd(savdir);
    case 9
        % PLOT FIGURE 7
        savdir = cd; 
        cd(D_JOINEDCUBES);
        ir = IEEE_runFDTDgpuDoubleCube('visuals',false,'useGPU',false); 
        cd(savdir);

% PLOT FIGURE 8

%%%%%%% SECTION V D - LATE REVERBERATION MODEL %%%%%%%

    case 10
        % Calculate Acoustic parameter Data from Shoebox Datasets
        IEEE_getAcousticParamsData( ACOUSTICPARAMS  );
        % PLOT FIGURE 10 from RIRS dataset and ART dataset
        IEEE_FIG_10_RT60values( ACOUSTICPARAMS );
    case 11
        % PRODUCE TABLE 3 from Acoustic Parameter dataset
        PARAMS = IEEE_TABLE3_AcousticParams( ACOUSTICPARAMS );
end

