function IEEE_FIG_5_Modal_Plot( RIRS )

fig(1) = figure;hold on;
fig(2) = figure;hold on;

%---- Plot Signals of Interest -----
    SN = 5; % source number
    RN = 4; % receiver number
    RC(1,:) = [21 20 19]; % reflection coefficients Fig1
    RC(2,:) = [1 2 3]; % reflection coefficients Fig2
    
    % colors RGB
    C(1,:) = [249 210 174]; % 86% Lum
    C(2,:) = [109 185 248]; % 72% Lum
    C(3,:) = [1 1 1];       % 0% Lum    
    C = C./255; %normalize
    
    % linewidth
    lw = [2 2 1];
    
    MODEL1 = 'ISMP';
    FS_1 = 48000;
    eta1 = 1;
    
    MODEL2 = 'FDTD3D';
    FS_2 = 18000;
    eta2 = 94;    % calibration parameter
%------------------------

N1 = 48000*2;
N2 = 48000*2;

% Get Modes of Geometry
dx = (344*sqrt(3))/18000;
[ax ta ob all] = roommodescalc(5.59413920826801-dx,4.00527126745816-dx,2.84672172728431-dx,344);

for fh = 1:2
    
    figure(fig(fh));
    
    % ---- Mark Modes -----
    if fh == 1    
        for n = 1:length(ax)
           h = plot([ax(n),ax(n)],[200 -200],'k'); 
           set(h,'LineWidth',0.2);
           set(h,'Color',[0.6 0.6 0.6]);
        end
        for n = 1:length(ta)
           h = plot([ta(n),ta(n)],[200 -200],'k');
           set(h,'LineWidth',0.2);
           set(h,'Color',[0.6 0.6 0.6]);
        end
    end
    for n = 1:length(ob)
       h = plot([ob(n),ob(n)],[200 -200],'k'); 
       set(h,'LineWidth',0.2);
       set(h,'Color',[0.6 0.6 0.6]);
    end
    % -----------------------
   
    for ir = 1:length(RC(fh,:))
        
        eval(['sig = RIRS.' MODEL1 '.S' num2str(SN) '.R' num2str(RC(fh,ir)) '(' num2str(RN) ',:).*eta1;']);
        sig1 = taperise(sig);

        eval(['sig = RIRS.' MODEL2 '.S' num2str(SN) '.R' num2str(RC(fh,ir)) '(' num2str(RN) ',:).*eta2;']);
        sig2 = taperise(sig);
        
        SIG1 = abs(fft(sig1,N1));
        SIG2 = abs(fft(sig2,N2));

        fP1 = (( 1:length(SIG1)).* FS_1 ) / N1; 
        fP2 = (( 1:length(SIG2)).* FS_2 ) / N2; 

        p1 = plot(fP1,20.*log10(SIG1),'k');
        hold on;
        p2 = plot(fP2,20.*log10(SIG2),':k');

        if fh == 1 && ir == 1 % plot uncalibrated result for comparison
            eval(['sig = RIRS.' MODEL2 '.S' num2str(SN) '.R' num2str(RC(fh,ir)) '(' num2str(RN) ',:);']);
            sig2 = taperise(sig);
            SIG2 = abs(fft(sig2,N2));
            fP2 = (( 1:length(SIG2)).* FS_2 ) / N2; 
            p3 = plot(fP2,20.*log10(SIG2),':k');
            set(p3,'LineWidth',lw(ir));
            set(p3,'Color',C(ir,:));
        end
        
        set(p1,'LineWidth',lw(ir));
        set(p1,'Color',C(ir,:));
        
        set(p2,'LineWidth',lw(ir));
        set(p2,'Color',C(ir,:));

        xlim([0 120]);
        ylim([-80 40]);
        set(gcf,'Position', [10,10,902,270;]);
        
    end

end
