function IEEEHybridCalibrationMain(mode)
%
% Script Author : Alex Southern (1)
% Email  : mrapsouthern@gmail.com
% Article Co-Authors: 
% Samuel Siltanen (1), Lauri Savioja (1), Damian Murphy
% 
% (1) Virtual Acoustics Team
% Department of Media Technology,
% Aalto University,
% Otaniemi,
% Espoo,
% Finland,
% 47001
%
% (2) AudioLab
% Department of Electronics,
% University of York,
% Heslington,
% York, UK,
% YO10 5DD
%
% The article discusses the calibration parameter in terms of the receiver 
% array at d = 1m from the source. This code will generate the dataset by
% peforming the 3D SRL FDTD simulations for the sampling frequencies. 
% This will be performed on the GPU if possible, depending on your MATLAB 
% release [2010a/b does not work, 2011a not tested, 2012a works]. When the 
% dataset has been computed once it will be loaded from .mat files on any 
% subsequent executions of this script. The data is processed firstly 
% for a number of cut-off frequencies in order to generate 
% the figure. Secondly, the data is processed for one cut-off frequency 
% 0.01 to compute the Table 1(a) for the measured calibration 
% parameters for each sampling frequency. These measured values are then 
% used to obtain the straight line defintion from which Table 1(b), 
% containing the predicted calibration values, are produced.
%
% List of required files that must be in the same folder:
% 
%   1: IEEEHybridCalibrationMain.m    (this file)
%   2: IEEECalibrationGenerateData.m  (perfroms FDTD simulations)
%   3: IEEECalibrationProcessData.m   (post process data for article)
%   4: h_ir_3D_1000.txt (Decoupled response for a tranparent 3D-FDTD source)

% Distance of Receivers from Source
d = 1;

% Sampling Rate to Investigate...
if nargin == 0
    mode = 2;
end
switch mode
    case 0 % These are used in the paper for obtaining the linear fit prediction 
        fs = [18000 20000 22000 24000 26000 28000 30000 32000 34000 36000 38000 40000 42000];
        % intialize linear coefficients as empty
        C = [];        
    case 1 % These are the sampling frequencies used in Table 1
        fs = [13000 14000 15000 16000 17000 18000 30000 42000];
        % intialize linear coefficients to those calculated by mode 0
        C = [5.437E-3 -3.6347];
    case 2 % These are the sampling frequencies used to generate the Figure.
        fs = 13000:1000:42000;
        % intialize linear coefficients to those calculated by mode 0
        C = [5.437E-3 -3.6347];
end

% Cut Off Frequencies
fc = 0.01:0.01:0.25;

display(' ');
display('Accompanying script for IEEE submission regarding the Calibration paramter');
display('Type help IEEEHybridCalibrationMain for more details.');
display(' ')
display('Generate any part of dataset that does not already exist...');

% Generate any parts of the dataset that do not already exist.
for k = 1:length(d)
    for i = 1:length(fs)  
    
        dstr = strrep(num2str(d(k)),'.','_');
        name = ['CalibrationData_' num2str(fs(i)) 'Hz_' dstr 'm.mat'];

        % Does data already exist?
        if exist ( name ) == 0
            % File does not exist - Create data
            [SRC REC] = IEEECalibrationModelSetup(fs(i),d(k));       
            tmp = IEEECalibrationGenerateData(fs(i),d(k),SRC,REC);    
            try
                R = gather( tmp ); % Gather data from GPU
            catch
                R = tmp;
            end  
            save(name,'R');
            display(['Saved data for ' name]);
        end        
    end
end

display(' ')
display('Dataset is computed, processing data...');
% Process Dataset and Create Figures for Article
IEEECalibrationProcessData( fs,d,fc,mode,C );