function nab = NormalizedAirAbsorption( d, ff )

% get absorption in dB/metre
alpha1m = getAirAbsorption(ff)/304;

[q m] = size(d);
if q < m
    d = d';
end

D = repmat( d, 1, length(alpha1m));
A = repmat( alpha1m, length(d), 1);

% convert to linear domain between 0 and 1
nab = exp( -(D.*A/20) * log(10) );
